/*                    QPUX-Kernel Schedulingg Header File                   */
/*              -------------------------------------------                 */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

#define MAX_MEMORY_SLOTS 4

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define DEF_PRIORITY	(20*HZ/100)	/* 200 ms time slices */
#define NR_TASKS     4     /*total number of tasks allowed apart from INIT */

/* different states a task can have*/
#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_WAITING		3
#define TASK_STOPPED		4
#define TASK_SWAPPING		5

/*
 * Scheduling policies
 */
#define SCHED_OTHER		0
#define SCHED_FIFO		1
#define SCHED_RR		2

/*
 * Limit the stack by to some sane default: root can always
 * increase this limit if needed..  8MB seems reasonable.
 */
#define _STK_LIM	(8*1024*1024)
#define INIT_RT_PRIORITY 15


/*
 * Per process flags
 */
#define PF_ALIGNWARN	0x00000001	/* Print alignment warning msgs */
					/* Not implemented yet, only for 486*/
#define PF_PTRACED	0x00000010	/* set if ptrace (0) has been called. */
#define PF_TRACESYS	0x00000020	/* tracing system calls */
#define PF_FORKNOEXEC	0x00000040	/* forked but didn't exec */
#define PF_SUPERPRIV	0x00000100	/* used super-user privileges */
#define PF_DUMPCORE	0x00000200	/* dumped core */
#define PF_SIGNALED	0x00000400	/* killed by a signal */

#define PF_STARTING	0x00000002	/* being created */
#define PF_EXITING	0x00000004	/* getting shut down */ 

#define PF_USEDFPU	0x00100000	/* Process used the FPU this quantum (SMP only) */

struct sched_param {
	int sched_priority; 
};

typedef int pid_t;


#define QUANTUM 100        //runtime quantum for a process

extern unsigned long volatile jiffies;
extern struct task_struct init_task;
extern struct task_struct * current;



/*
 * This struct defines the way the registers are stored on the stack during *
 * a system call/exception. I am saving all registers no compromise, bcos i *
 * am a bad GUY :-).  */

/* change anything here then also change in entry.c */

struct pt_regs { 
	/*
	 * saved main processor registers
	 */
	long	 reg0,  reg1,  reg2,  reg3,  reg4,  reg5,  reg6,  reg7;
	long	 reg8,  reg9, reg10, reg11, reg12, reg13, reg14, reg15;
	long	reg16, reg17, reg18, reg19, reg20, reg21, reg22, reg23;
        long	reg24, reg25, reg26, reg27, reg28, reg29, reg30, reg31;

	/*
	 * Saved special registers
	 */
	long	spsr;
        long    LR;
  long  conditional_regs;
};


struct mm_pointers {
  long start;
  long end;
};



/* changing order for these might result in system crash.. change at ur own *
 * risk and if u know the consequences. If u wanna add something,add at the*
 * end  of structure */

#define INIT_TASK \
/* state    */	  { 0, \
/* Pid      */      0, \
/* priority */      0, \
/* prev_task*/      &init_task, \
/* next_task*/	    &init_task, \
/* prev_run */	    &init_task, \
/* next_run */	    &init_task, \
/* counter  */      DEF_PRIORITY,  \
/* timeout  */      0,  \
/* pt_regs  */      0,  \
/* mm_struct*/      0,  \
/* proc links*/     &init_task,&init_task,NULL,NULL,NULL,NULL, \
/* policy    */     SCHED_OTHER,INIT_RT_PRIORITY,  \
/* exit_code,..*/   0,0,0,    \
/* signals */       &init_signals}


struct task_struct{
        int state;
        int pid;
	int priority;
        struct task_struct *prev_task,*next_task;
        struct task_struct *prev_run, *next_run;
        long counter;
        unsigned long timeout;
        struct pt_regs *regs;
        struct mm_struct *mm;
	struct task_struct *p_opptr, *p_pptr, *p_cptr, *p_ysptr, *p_osptr;
	struct wait_queue *wait_chldexit;	/* for wait4() */
        unsigned long policy,rt_priority;
	int exit_code, exit_signal;
	unsigned long signal;
/* signal handlers */ 
	struct signal_struct *sig;
};

  
struct mm_struct {
        unsigned long start_code,end_code;
        unsigned long start_data, end_data,start_kernel_stack;//,kernel_sp;
	unsigned long task_sp,task_fp,end_stack;
	unsigned long def_flags;
        unsigned int memory_slot;
        unsigned int task_stack_size;
};

#define INIT_MM { \
		1, \
		((unsigned long)&init_thread()), 0, 0, 0, \
		0, 0, 0, 0, \
		0, 0, 0, 0, \
        	0, 0}


#ifndef NULL
#define NULL ((void *) 0)
#endif

#define for_each_task(p) \
	for (p = &init_task ; (p = p->next_run) != &init_task ; )


/*                    QPUX-Kernel Timer Header File                         */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define WAIT_TIME 4     /* number of ticks a process waits in wait queue */

struct timer_struct {
	unsigned long expires;
	void (*fn)(void);
}; /*for now i am not using this but i may use it in future*/


/*
 * The "data" field is in case you want to use the same
 * timeout function for several timeouts. You can use this
 * to distinguish between the different invocations.
 */
struct timer_list {
	struct timer_list *next;
	struct timer_list *prev;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);
};


 

/* This is going to be the header of all timer list just like  INIT_TASK */

#define INIT_TIMER  \
/* next     */	  { &head_timer, \
/* prev     */      &head_timer, \
/* expires  */      0x7D0,   \
/* data     */    (unsigned long) &head_timer, \
/* function */    process_waittimeout  \
  }


  

  





/*               CUP-OS  Error Numbers Header File                          */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/



#define	EPERM		 1	/* Operation not permitted */
#define	ENOENT		 2	/* No such file or directory */
#define	ESRCH		 3	/* No such process */
#define	EINTR		 4	/* Interrupted system call */
#define	EIO		 5	/* I/O error */
#define	ENXIO		 6	/* No such device or address */
#define	E2BIG		 7	/* Arg list too long */
#define	ENOEXEC		 8	/* Exec format error */
#define	EBADF		 9	/* Bad file number */
#define	ECHILD		10	/* No child processes */
#define	EAGAIN		11	/* Try again */
#define	ENOMEM		12	/* Out of memory */
#define	EACCES		13	/* Permission denied */
#define	EFAULT		14	/* Bad address */
#define	ENOTBLK		15	/* Block device required */
#define	EBUSY		16	/* Device or resource busy */
#define	EEXIST		17	/* File exists */
#define	EXDEV		18	/* Cross-device link */
#define	ENODEV		19	/* No such device */
#define	ENOTDIR		20	/* Not a directory */
#define	EISDIR		21	/* Is a directory */
#define	EINVAL		22	/* Invalid argument */
#define	ENFILE		23	/* File table overflow */
#define	EMFILE		24	/* Too many open files */
#define	ENOTTY		25	/* Not a typewriter */
#define	ETXTBSY		26	/* Text file busy */
#define	EFBIG		27	/* File too large */
#define	ENOSPC		28	/* No space left on device */
#define	ESPIPE		29	/* Illegal seek */
#define	EROFS		30	/* Read-only file system */
#define	EMLINK		31	/* Too many links */
#define	EPIPE		32	/* Broken pipe */
#define	EDOM		33	/* Math argument out of domain of func */
#define	ERANGE		34	/* Math result not representable */
#define	EDEADLK		35	/* Resource deadlock would occur */
#define	ENAMETOOLONG	36	/* File name too long */
#define	ENOLCK		37	/* No record locks available */
#define	ENOSYS		38	/* Function not implemented */
#define	ENOTEMPTY	39	/* Directory not empty */
#define	ELOOP		40	/* Too many symbolic links encountered */
#define	EWOULDBLOCK	EAGAIN	/* Operation would block */
#define	ENOMSG		42	/* No message of desired type */
#define	EIDRM		43	/* Identifier removed */
#define	ECHRNG		44	/* Channel number out of range */
#define	EL2NSYNC	45	/* Level 2 not synchronized */
#define	EL3HLT		46	/* Level 3 halted */
#define	EL3RST		47	/* Level 3 reset */
#define	ELNRNG		48	/* Link number out of range */
#define	EUNATCH		49	/* Protocol driver not attached */
#define	ENOCSI		50	/* No CSI structure available */
#define	EL2HLT		51	/* Level 2 halted */
#define	EBADE		52	/* Invalid exchange */
#define	EBADR		53	/* Invalid request descriptor */
#define	EXFULL		54	/* Exchange full */
#define	ENOANO		55	/* No anode */
#define	EBADRQC		56	/* Invalid request code */
#define	EBADSLT		57	/* Invalid slot */
#define	EDEADLOCK	58	/* File locking deadlock error */
#define	EBFONT		59	/* Bad font file format */
#define	ENOSTR		60	/* Device not a stream */
#define	ENODATA		61	/* No data available */
#define	ETIME		62	/* Timer expired */
#define	ENOSR		63	/* Out of streams resources */
#define	ENONET		64	/* Machine is not on the network */
#define	ENOPKG		65	/* Package not installed */
#define	EREMOTE		66	/* Object is remote */
#define	ENOLINK		67	/* Link has been severed */
#define	EADV		68	/* Advertise error */
#define	ESRMNT		69	/* Srmount error */
#define	ECOMM		70	/* Communication error on send */
#define	EPROTO		71	/* Protocol error */
#define	EMULTIHOP	72	/* Multihop attempted */
#define	EDOTDOT		73	/* RFS specific error */
#define	EBADMSG		74	/* Not a data message */
#define	EOVERFLOW	75	/* Value too large for defined data type */
#define	ENOTUNIQ	76	/* Name not unique on network */
#define	EBADFD		77	/* File descriptor in bad state */
#define	EREMCHG		78	/* Remote address changed */
#define	ELIBACC		79	/* Can not access a needed shared library */
#define	ELIBBAD		80	/* Accessing a corrupted shared library */
#define	ELIBSCN		81	/* .lib section in a.out corrupted */
#define	ELIBMAX		82	/* Attempting to link in too many shared libraries */
#define	ELIBEXEC	83	/* Cannot exec a shared library directly */
#define	EILSEQ		84	/* Illegal byte sequence */
#define	ERESTART	85	/* Interrupted system call should be restarted */
#define	ESTRPIPE	86	/* Streams pipe error */
#define	EUSERS		87	/* Too many users */
#define	ENOTSOCK	88	/* Socket operation on non-socket */
#define	EDESTADDRREQ	89	/* Destination address required */
#define	EMSGSIZE	90	/* Message too long */
#define	EPROTOTYPE	91	/* Protocol wrong type for socket */
#define	ENOPROTOOPT	92	/* Protocol not available */
#define	EPROTONOSUPPORT	93	/* Protocol not supported */
#define	ESOCKTNOSUPPORT	94	/* Socket type not supported */
#define	EOPNOTSUPP	95	/* Operation not supported on transport endpoint */
#define	EPFNOSUPPORT	96	/* Protocol family not supported */
#define	EAFNOSUPPORT	97	/* Address family not supported by protocol */
#define	EADDRINUSE	98	/* Address already in use */
#define	EADDRNOTAVAIL	99	/* Cannot assign requested address */
#define	ENETDOWN	100	/* Network is down */
#define	ENETUNREACH	101	/* Network is unreachable */
#define	ENETRESET	102	/* Network dropped connection because of reset */
#define	ECONNABORTED	103	/* Software caused connection abort */
#define	ECONNRESET	104	/* Connection reset by peer */
#define	ENOBUFS		105	/* No buffer space available */
#define	EISCONN		106	/* Transport endpoint is already connected */
#define	ENOTCONN	107	/* Transport endpoint is not connected */
#define	ESHUTDOWN	108	/* Cannot send after transport endpoint shutdown */
#define	ETOOMANYREFS	109	/* Too many references: cannot splice */
#define	ETIMEDOUT	110	/* Connection timed out */
#define	ECONNREFUSED	111	/* Connection refused */
#define	EHOSTDOWN	112	/* Host is down */
#define	EHOSTUNREACH	113	/* No route to host */
#define	EALREADY	114	/* Operation already in progress */
#define	EINPROGRESS	115	/* Operation now in progress */
#define	ESTALE		116	/* Stale NFS file handle */
#define	EUCLEAN		117	/* Structure needs cleaning */
#define	ENOTNAM		118	/* Not a XENIX named type file */
#define	ENAVAIL		119	/* No XENIX semaphores available */
#define	EISNAM		120	/* Is a named type file */
#define	EREMOTEIO	121	/* Remote I/O error */
#define	EDQUOT		122	/* Quota exceeded */



/*                CUP-OS Assembly Instruction macros defined here           */
/*              --------------------------------------------------          */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/



#define CCB_BASE 0xffffbf00
#define CCB_END  0xffffffff

/* Important note here is that i am using definitions of variables that *
 * were defined in some other files here. As i intend to club all the files *
 * into one file manually i am not redefining then here. compiling this     *
 * single file will flood u with errors */


//**************************************************************************** 
//* Registers Usage only for SuperUser
//****************************************************************************
asm("FP = r27\n\t"
  "SP   = r28\n\t"
  "PSR  = r29\n\t"   
  "SPSR = r30\n\t"   
  "LR   = r31\n\t");

/*************************************************************************** 
 *      Macros 
 ****************************************************************************/

/* PUSH AND POP MACROS */
/* when pushed increments the stack pointer by 4 bytes and stores Register *
 * contents to it and similarly when poped loads register from stack and   *
 * decrements the stack by 4 bytes...as simple as it looks                 */

__asm__(".macro push(rname)\n\t"  
"addi SP,SP,-4\n\t"  
"st rname,SP,0\n\t"   
".endm\n\t"    

".macro pop(rname)\n\t" 
"ld rname,SP,0\n\t"    
"addi SP,SP,4\n\t"    
".endm\n\t");

/* MACRO TO USE SOURCE REGISTERS FROM TWO DIFFERENT SETS */

/* This is done by copying contents of reg of one set to reg of other set *
 * so that sources are now in one set after macro is done remember that   *
 * default set for READ and WRITE is SET2                                 */

__asm__ (".macro set1_to_set2(set1,set2)\n\t"
		     "chrs 2\n\t"       
		     "mov set2,set1\n\t" 
		     "chrs 3\n\t"        
		     ".endm\n\t");

__asm__ (".macro set2_to_set1(set2,set1)\n\t"
		     "chrs 1\n\t"       
		     "mov set1,set2\n\t" 
		     "chrs 3\n\t"       
		     ".endm\n\t");
/* get the address of Current task_struct into specified reg*/

__asm__ (".macro get_current(reg)\n\t"
	     "ldra r16,current\n\t"
	     "ld   reg,r16,0\n\t"
	 ".endm\n\t");

/* Load variable in the specified register */
__asm__ (".macro load_variable(variable,reg)\n\t"
         "ldra reg,variable\n\t"
         "ld reg,reg,0\n\t"
	 ".endm\n\t");

/* macro for siabling and enabling interrupts */
__asm__(".macro disable_interrupts\n\t"
	"di\n\t"
	"nop\n\t"
	".endm\n\t"	);
__asm__(".macro enable_interrupts\n\t"
	"ei\n\t"
	"nop\n\t"
	".endm\n\t"	);

/* These macros are used to block interrupts and restore them using      *
 * The INT_MASK register in CCB . Using this macros has an advantage     *
 * of enabling interrupts to their states that were before blocking them */
__asm__(".macro block_interrupts(variable)\n\t"
	"push r10\n\t"
	"push r11\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"ld   r11,r10,INT_MASK_OFFSET\n\t"
	"ldra r10,variable\n\t"
	"st   r11,r10,0\n\t"
	"di   \n\t"
	"nop  \n\t"
	"pop  r11\n\t"
	"pop  r10\n\t"
	".endm\n\t");

__asm__(".macro restore_interrupts(variable)\n\t"
	"push r10\n\t"
	"push r11\n\t"
	"ldra r10,variable\n\t"
	"ld   r11,r10,0\n\t"
	"lli  r10,CCB_BASE_REMAPPED_LO\n\t" 
	"lui  r10,CCB_BASE_REMAPPED_HI\n\t"
	"st   r11,r10,INT_MASK_OFFSET\n\t"
	"nop  \n\t"
	"pop  r11\n\t"
	"pop  r10\n\t"
	".endm\n\t");


/* Macro to add syscall_address into its address with the assumption  *
 * that r16 has address of syscalls[]'s arrayth address to which this *
 * entry should be added                                              */

 asm(".macro entry(sys_call_name)\n\t" 
         "ldra r17,sys_call_name\n\t"
         "st r17,r16,0\n\t"
         "addiu r16,r16,4\n\t"
     ".endm\n\t");


/*                CUP-OS All Defines for saving registers                   */
/*              ------------------------------------------                  */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


/*
 * entry.h and entry.c contains the system-call and fault low-level handling routines. This also contains the timer-interrupt handler, as well as all interrupts * and faults that can result in a task-switch.
 *
 * NOTE: This code handles signal-recognition, which happens every time
 * after a timer-interrupt and after each system call.*/

#define NR_syscalls 189
#define count_exception 11  // Number of exceptions to date in coffee
#define KERNEL_STACK_POINTER 0xffff

long NR_systemcall_A_L = NR_syscalls;  //for assembler

long KERNEL_FP = KERNEL_STACK_POINTER;
long KERNEL_SP = KERNEL_STACK_POINTER;

//  These are offsets into task_struct

asm("state = 0\n\t"
"Pid       = 4\n\t"
"priority  = 8\n\t"
"prev_task = 12\n\t"
"next_task = 16\n\t"
"prev_run  = 20\n\t"
"next_run  = 24\n\t"
"counter   = 28\n\t"
"timeout   = 32\n\t"
"pt_regs   = 36\n\t"
"mm_struct = 40\n\t");






//________________________________________________________________________//

/* saves all set2 registers on the stack except PSR bcos u cant write back *
 * to it when u try to restore :-(        bad bad bad register             */

#define SAVE_ALL \
asm("chrs 3\n\t"  \
"push r0\n\t"  \
"push r1\n\t"  \
"push r2\n\t"  \
"push r3\n\t"  \
"push r4\n\t"  \
"push r5\n\t"  \
"push r6\n\t"  \
"push r7\n\t"  \
"push r8\n\t"  \
"push r9\n\t"  \
"push r10\n\t" \
"push r11\n\t" \
"push r12\n\t" \
"push r13\n\t"  \
"push r14\n\t"  \
"push r15\n\t"  \
"push r16\n\t"  \
"push r17\n\t"  \
"push r18\n\t"  \
"push r19\n\t"  \
"push r20\n\t"  \
"push r21\n\t"  \
"push r22\n\t"  \
"push r23\n\t"  \
"push r24\n\t"  \
"push r25\n\t"  \
"push r26\n\t"  \
"push r27\n\t"  \
"push r28\n\t"  \
"push SPSR\n\t" \
"push LR\n\t"   \
"scon r0\n\t"   \
"push r0\n\t");


#define RESTORE_ALL  \
asm("pop r0\n\t"   \
"rcon r0\n\t"  \
"pop LR\n\t"   \
"pop SPSR\n\t" \
"pop r28\n\t"  \
"pop r27\n\t"  \
"pop r26\n\t"  \
"pop r25\n\t"  \
"pop r24\n\t"  \
"pop r23\n\t"  \
"pop r22\n\t"  \
"pop r21\n\t"  \
"pop r20\n\t"  \
"pop r19\n\t"  \
"pop r18\n\t"  \
"pop r17\n\t"  \
"pop r16\n\t"  \
"pop r15\n\t"  \
"pop r14\n\t"  \
"pop r13\n\t"  \
"pop r12\n\t"  \
"pop r11\n\t"  \
"pop r10\n\t"  \
"pop r9\n\t"   \
"pop r8\n\t"   \
"pop r7\n\t"   \
"pop r6\n\t"   \
"pop r5\n\t"   \
"pop r4\n\t"   \
"pop r3\n\t"   \
"pop r2\n\t"   \
"pop r1\n\t"   \
"pop r0\n\t");


/*\/* saves and restores SPSR ,PR31 *\/ i no more need it

#define SAVE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"st SPSR,r17,128\n\t"        \
"st LR,r17,132\n\t");

#define RESTORE_SPSR_PR31     \
asm("chrs 3\n\t"  \
"get_current r16\n\t"       \
"ld r17,r16,pt_regs\n\t"     \
"ld SPSR,r17,128\n\t"        \
"ld LR,r17,132\n\t");   */

#define SAVE_STACK_POINTER   \
asm("ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"chrs 2\n\t"                 \
"st SP,r17,20\n\t"           \
"st FP,r17,24\n\t"           \
"chrs 3\n\t"     \
"ldra r17,KERNEL_FP\n\t"   \
"ld SP,r17,0\n\t"           \
"ld FP,r17,0\n\t");

#define RESTORE_STACK_POINTER \
asm("ldra r17,KERNEL_FP\n\t"  \
"st FP,r17,0\n\t"       \
"ldra r16,current\n\t"     \
"ld  r16,r16,0\n\t"       \
"ld r17,r16,mm_struct\n\t"   \
"chrs 1\n\t"                 \
"ld SP,r17,20\n\t"           \
"ld FP,r17,24\n\t"           \
"chrs 3\n\t");

#define MOVE_INCOMING_ARGUMENTS  \
asm("chrs 2\n\t"        \
"mov r0,r0\n\t"         \
"mov r1,r1\n\t"         \
"mov r2,r2\n\t"         \
"mov r3,r3\n\t"         \
"mov r4,r4\n\t"         \
"mov r5,r5\n\t"         \
"chrs 3\n\t");


/*  Trying to get the address of current "pt_regs" and store all user regs   *
 *  into it . It might be useful for task to know its register contents      *
 *   .The code might not be self explanatory..sorry          */

#define SAVE_USR_PT_REGS  \
asm("ldra r0,current\n\t"  \
"ld   r1,r0,0\n\t"     \
"addiu r1,r1,pt_regs\n\t"   \
"ld r1,r1,0\n\t"      \
"chrs 2\n\t"            \
"mov r2,r0\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,0\n\t"  \
"chrs 2\n\t"            \
"mov r2,r1\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,4\n\t"  \
"chrs 2\n\t"            \
"mov r2,r2\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,8\n\t"  \
"chrs 2\n\t"            \
"mov r2,r3\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,12\n\t"  \
"chrs 2\n\t"            \
"mov r2,r4\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,16\n\t"  \
"chrs 2\n\t"            \
"mov r2,r5\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,20\n\t"  \
"chrs 2\n\t"            \
"mov r2,r6\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,24\n\t"  \
"chrs 2\n\t"            \
"mov r2,r7\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,28\n\t"  \
"chrs 2\n\t"            \
"mov r2,r8\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,32\n\t"  \
"chrs 2\n\t"            \
"mov r2,r9\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,36\n\t"  \
"chrs 2\n\t"            \
"mov r2,r10\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,40\n\t"  \
"chrs 2\n\t"            \
"mov r2,r11\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,44\n\t"  \
"chrs 2\n\t"            \
"mov r2,r12\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,48\n\t"  \
"chrs 2\n\t"            \
"mov r2,r13\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,52\n\t"  \
"chrs 2\n\t"            \
"mov r2,r14\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,56\n\t"  \
"chrs 2\n\t"            \
"mov r2,r15\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,60\n\t"  \
"chrs 2\n\t"            \
"mov r2,r16\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,64\n\t"  \
"chrs 2\n\t"            \
"mov r2,r17\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,68\n\t"  \
"chrs 2\n\t"            \
"mov r2,r18\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,72\n\t"  \
"chrs 2\n\t"            \
"mov r2,r19\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,76\n\t"  \
"chrs 2\n\t"            \
"mov r2,r20\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,80\n\t"  \
"chrs 2\n\t"            \
"mov r2,r21\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,84\n\t"  \
"chrs 2\n\t"            \
"mov r2,r22\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,88\n\t"  \
"chrs 2\n\t"            \
"mov r2,r23\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,92\n\t"  \
"chrs 2\n\t"            \
"mov r2,r24\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,96\n\t"  \
"chrs 2\n\t"            \
"mov r2,r25\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,100\n\t"  \
"chrs 2\n\t"            \
"mov r2,r26\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,104\n\t"  \
"chrs 2\n\t"            \
"mov r2,r27\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,108\n\t"  \
"chrs 2\n\t"            \
"mov r2,r28\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,112\n\t"  \
"chrs 2\n\t"            \
"mov r2,r29\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,116\n\t"  \
"chrs 2\n\t"            \
"mov r2,r30\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,120\n\t"  \
"chrs 2\n\t"            \
"mov r2,r31\n\t"     \
"chrs 3\n\t"            \
"st r2,r1,124\n\t"  \
"st r30,r1,128\n\t"     \
"st r31,r1,132\n\t"     \
"scon r16\n\t"        \
"st r16,r1,136\n\t");


//set2 are super user registers and set1 are user registers *** IMPORTANT NOTE**
#define RESTORE_USR_PT_REGS  \
asm("ldra r16,current\n\t"     \
"ld  r1,r16,0\n\t"       \
"addiu r1,r1,36\n\t"   \
"ld r1,r1,0\n\t"       \
"ld r2,r1,0\n\t"           \
"chrs 1\n\t"        \
"mov r0,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,4\n\t"  \
"chrs 1\n\t"        \
"mov r1,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,8\n\t"  \
"chrs 1\n\t"        \
"mov r2,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,12\n\t"  \
"chrs 1\n\t"        \
"mov r3,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,16\n\t"  \
"chrs 1\n\t"        \
"mov r4,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,20\n\t"  \
"chrs 1\n\t"        \
"mov r5,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,24\n\t"  \
"chrs 1\n\t"        \
"mov r6,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,28\n\t"  \
"chrs 1\n\t"        \
"mov r7,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,32\n\t"  \
"chrs 1\n\t"        \
"mov r8,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,36\n\t"  \
"chrs 1\n\t"        \
"mov r9,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,40\n\t"  \
"chrs 1\n\t"        \
"mov r10,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,44\n\t"  \
"chrs 1\n\t"        \
"mov r11,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,48\n\t"  \
"chrs 1\n\t"        \
"mov r12,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,52\n\t"  \
"chrs 1\n\t"        \
"mov r13,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,56\n\t"  \
"chrs 1\n\t"        \
"mov r14,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,60\n\t"  \
"chrs 1\n\t"        \
"mov r15,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,64\n\t"  \
"chrs 1\n\t"        \
"mov r16,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,68\n\t"  \
"chrs 1\n\t"        \
"mov r17,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,72\n\t"  \
"chrs 1\n\t"        \
"mov r18,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,76\n\t"  \
"chrs 1\n\t"        \
"mov r19,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,80\n\t"  \
"chrs 1\n\t"        \
"mov r20,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,84\n\t"  \
"chrs 1\n\t"        \
"mov r21,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,88\n\t"  \
"chrs 1\n\t"        \
"mov r22,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,92\n\t"  \
"chrs 1\n\t"        \
"mov r23,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,96\n\t"  \
"chrs 1\n\t"        \
"mov r24,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,100\n\t"  \
"chrs 1\n\t"        \
"mov r25,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,104\n\t"  \
"chrs 1\n\t"        \
"mov r26,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,108\n\t"  \
"chrs 1\n\t"        \
"mov r27,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,112\n\t"  \
"chrs 1\n\t"        \
"mov r28,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,116\n\t"  \
"chrs 1\n\t"        \
"mov r29,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,120\n\t"  \
"chrs 1\n\t"        \
"mov r30,r2\n\t"     \
"chrs 3\n\t"        \
"ld r2,r1,124\n\t"  \
"chrs 1\n\t"        \
"mov r31,r2\n\t"     \
"chrs 3\n\t"        \
"ld r30,r1,128\n\t"  \
"ld r31,r1,132\n\t"  \
"ld r16,r1,136\n\t"  \
"rcon r16\n\t");

/* Looks bad isnt it.. sorry ..ill try not to do so bad again :-)  */  


/*                    System_Call Table       */
/*                 Adding all entries Here    */
/*
long *system_call_table[]={&sys_setup,
&sys_exit,
&sys_vfork,
&sys_read,
&sys_write,
&sys_open,
&sys_close,
&sys_waitpid,
&sys_creat,
&sys_link,
&sys_unlink,
&sys_execve,
&sys_chdir,
&sys_time,
&sys_mknod,
&sys_chmod,
&sys_chown,
&sys_break,
&sys_oldstat,
&sys_lseek,
&sys_getpid,
&sys_mount,
&sys_umount,
&sys_setuid,
&sys_getuid,
&sys_ptrace,
&sys_alarm,
&sys_oldfstat,
&sys_pause,
&sys_utime,
&sys_stty,
&sys_gtty,
&sys_access,
&sys_nice,
&sys_ftime,
&sys_sync,
&sys_kill,
&sys_rename,
&sys_mkdir,
&sys_rmdir,
&sys_dup,
&sys_pipe,
&sys_times,
&sys_prof,
&sys_brk,
&sys_setgid,
&sys_getgid,
&sys_signal,
&sys_geteuid,
&sys_getegid,
&sys_acct,
&sys_phys,
&sys_lock,
&sys_ioctl,
&sys_fcntl,
&sys_mpx,
&sys_setpgid,
&sys_ulimit,
&sys_oldolduname,
&sys_umask,
&sys_chroot,
&sys_ustat,
&sys_dup2,
&sys_getppid,
&sys_getpgrp ,
&sys_setsid ,
&sys_sigaction,
&sys_sgetmask,
&sys_ssetmask,
&sys_setreuid,
&sys_setregid,
&sys_sigsuspend,
&sys_sigpending,
&sys_sethostname,
&sys_setrlimit,
&sys_getrlimit,
&sys_getrusage,
&sys_gettimeofday,
&sys_settimeofday,
&sys_getgroups,
&sys_setgroups,
&sys_select,
&sys_symlink,
&sys_oldlstat,
&sys_readlink,
&sys_uselib,
&sys_swapon,
&sys_reboot,
&sys_readdir,
&sys_mmap,
&sys_munmap,
&sys_truncate,
&sys_ftruncate,
&sys_fchmod,
&sys_fchown,
&sys_getpriority,
&sys_setpriority,
&sys_profil,
&sys_statfs,
&sys_fstatfs,
&sys_ioperm,
&sys_socketcall,
&sys_&syslog,
&sys_setitimer,
&sys_getitimer,
&sys_stat,
&sys_lstat,
&sys_fstat,
&sys_olduname,
&sys_iopl,
&sys_vhangup,
&sys_idle,
&sys_vm86,
&sys_wait4,
&sys_swapoff,
&sys_&sysinfo,
&sys_ipc,
&sys_fsync,
&sys_sigreturn,
&sys_clone,
&sys_setdomainname,
&sys_uname,
&sys_modify_ldt,
&sys_adjtimex,
&sys_mprotect,
&sys_sigprocmask,
&sys_create_module,
&sys_init_module,
&sys_delete_module,
&sys_get_kernel_syms,
&sys_quotactl,
&sys_getpgid,
&sys_fchdir,
&sys_bdflush,
&sys_&sysfs,
&sys_personality,
&sys_afs_&syscall,
&sys_setfsuid,
&sys_setfsgid,
&sys__llseek,
&sys_getdents,
&sys__newselect,
&sys_flock,
&sys_msync,
&sys_readv,
&sys_writev,
&sys_getsid,
&sys_fdatasync,
&sys__&sysctl,
&sys_mlock,
&sys_munlock,
&sys_mlockall,
&sys_munlockall,
&sys_sched_setparam,
&sys_sched_getparam,
&sys_sched_setscheduler,
&sys_sched_getscheduler,
&sys_sched_yield,
&sys_sched_get_priority_max,
&sys_sched_get_priority_min,
&sys_sched_rr_get_interval,
&sys_nanosleep,
&sys_mremap,
&sys_poll,
&sys_getpmsg,
&sys_putpmsg
}
*/ 



/*--------------------------------------------------------------------------*/
/*                    CUP-OS  scheduler routines                            */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Modified on       --->                                                  */
/*--------------------------------------------------------------------------*/


extern struct task_struct *current;
extern struct task_struct idle_task;
int nr_running = 4;    //no task initially in runqueue
int Global_Pid = 1;
int need_resched = 1;  // let scheduler be activated in the beginning
unsigned long volatile jiffies=0;
struct task_struct *task[NR_TASKS]={&init_task,};


//struct task_struct init_task = INIT_TASK;

void check_priority(struct task_struct * p)
{
  if ( p->priority > current->priority )
    need_resched = 1;
  //    schedule();
}



void add_to_runqueue(struct task_struct * p)
{
#if 1	/* sanity tests */
	if (p->next_run || p->prev_run) {
//		printf("task already on run-queue\n");
		return;
	}
#endif
        nr_running++;
        p->timeout = WAIT_TIME;
        //p->counter = QUANTUM;
        (p->prev_run = init_task.prev_run)->next_run = p;
	p->next_run = &init_task;
	init_task.prev_run = p;
	check_priority(p);
	return;
}

inline void wake_up_process(struct task_struct * p)
{
  //	unsigned long flags;

  //	save_flags(flags);
  //	cli();
      	p->state = TASK_RUNNING;
	if (!p->next_run)
	  {
                p->next_task = p->prev_task = NULL;
		add_to_runqueue(p);
	  }
  //	restore_flags(flags);
	return;
}
   


void process_waittimeout(unsigned long __data)
{
	struct task_struct * p = (struct task_struct *) __data;

	p->timeout = WAIT_TIME;
	wake_up_process(p); /*  defined in sched.h   */
	return;
}


struct timer_list head_timer = INIT_TIMER;
struct task_struct *current=&init_task; /*points to currect task under execution */

extern inline void init_timer(struct timer_list * timer);

//int main()
//{}




/* This verifies if the task is really in run queue so that it may be deleted.
   Note that the memory allocated to this is not removed, just its information
   regarding run queue is removed linking its neighbours in the queue together 
   also decrements the count of number of tasks in run queue  */

inline void del_from_runqueue(struct task_struct * p)
{
	struct task_struct *next = p->next_run;
	struct task_struct *prev = p->prev_run;

#if 1	/* sanity tests */
	if (!next || !prev) {
//		printf("task not on run-queue\n");
		return;
	}
#endif
	if (p == &init_task) 
          {
//	    printf("idle task may not sleep\n");
	    return;
	  }
	nr_running--;
        p->state = TASK_WAITING;
	next->prev_run = prev;
	prev->next_run = next;
	p->next_run = NULL;
	p->prev_run = NULL;
	if (p = current) 
	   need_resched = 1;
	//schedule();
	return;
}

/* We dont actually need so many wait queues now but let me see how it ends up
   This is some what peculiar, we have only one queue when we wrote this 
   function.... linus used some what complex waitqueues  */

void add_to_waitqueue(struct task_struct *to_wait)
{   struct task_struct *ptr = to_wait;

	    if (ptr->next_task != NULL || ptr->prev_task != NULL) 
             {
//	   printf("task already on wait-queue\n");
		   return;
	     }
       
        (ptr->prev_task = init_task.prev_task)->next_task = ptr;
	ptr->next_task = &init_task;
	init_task.prev_task = ptr;
	return;
    
} 

/* Susheel u are bad programmer :-( ,for this print to work u need to write
   VGA drivers idiot */
/* void Print_Runqueue( ) */
/* { */
/* 	struct task_struct* tmp_init = init_task.next_run; */


/* 	//Adding these printf bcos PrintTaskStruct doesnt print INIT */
/*        printf("PID:: 0,  PRIORITY:: 1 ----> INIT\n"); */

/*       while ( tmp_init != &init_task) */
/* 	{ */
/*               printf("PID:: %d,  PRIORITY:: %d\n",tmp_init->pid, tmp_init->priority); */
/* 	      tmp_init=tmp_init->next_run; */
/* 	}	;        */

/* } */
  

inline void move_last_runqueue(struct task_struct * p)
{
	struct task_struct *next = p->next_run;
	struct task_struct *prev = p->prev_run;

	/* remove from list */
	next->prev_run = prev;
	prev->next_run = next;
	/* add back to list */
	p->next_run = &init_task;
	prev = init_task.prev_run;
	init_task.prev_run = p;
	p->prev_run = prev;
	prev->next_run = p;
}

 inline int goodness(struct task_struct * p, struct task_struct * prev)
{
	int weight;

	/*
	 * Realtime process, select the first one on the
	 * runqueue (taking priorities within processes
	 * into account).
	 */
	if (p->policy != SCHED_OTHER)
		return 1000 + p->rt_priority;

	/*
	 * Give the process a first-approximation goodness value
	 * according to the number of clock-ticks it has left.
	 *
	 * Don't do any other calculations if the time slice is
	 * over..
	 */

	weight = p->counter;
	if (weight) {

		/* .. and a slight advantage to the current process */
		if (p == prev)
			weight += 1;
	}

	return weight;
}



#define TVN_BITS 6
#define TVR_BITS 8
#define TVN_SIZE (1 << TVN_BITS)
#define TVR_SIZE (1 << TVR_BITS)
#define TVN_MASK (TVN_SIZE - 1)
#define TVR_MASK (TVR_SIZE - 1)

#define SLOW_BUT_DEBUGGING_TIMERS 0

struct timer_vec {
        int index;
        struct timer_list *vec[TVN_SIZE];
};

struct timer_vec_root {
        int index;
        struct timer_list *vec[TVR_SIZE];
};

 struct timer_vec tv5 = { 0 };
 struct timer_vec tv4 = { 0 };
 struct timer_vec tv3 = { 0 };
 struct timer_vec tv2 = { 0 };
 struct timer_vec_root tv1 = { 0 };

 struct timer_vec * const tvecs[] = {
	(struct timer_vec *)&tv1, &tv2, &tv3, &tv4, &tv5
};

#define NOOF_TVECS (sizeof(tvecs) / sizeof(tvecs[0]))

 unsigned long timer_jiffies = 0;

 inline void insert_timer(struct timer_list *timer,
				struct timer_list **vec, int idx)
{
	if ((timer->next = vec[idx]))
		vec[idx]->prev = timer;
	vec[idx] = timer;
	timer->prev = (struct timer_list *)&vec[idx];
}

 inline void internal_add_timer(struct timer_list *timer)
{
	/*
	 * must be cli-ed when calling this
	 */
	unsigned long expires = timer->expires;
	unsigned long idx = expires - timer_jiffies;

	if (idx < TVR_SIZE) {
		int i = expires & TVR_MASK;
		insert_timer(timer, tv1.vec, i);
	} else if (idx < 1 << (TVR_BITS + TVN_BITS)) {
		int i = (expires >> TVR_BITS) & TVN_MASK;
		insert_timer(timer, tv2.vec, i);
	} else if (idx < 1 << (TVR_BITS + 2 * TVN_BITS)) {
		int i = (expires >> (TVR_BITS + TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv3.vec, i);
	} else if (idx < 1 << (TVR_BITS + 3 * TVN_BITS)) {
		int i = (expires >> (TVR_BITS + 2 * TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv4.vec, i);
	} else if (expires < timer_jiffies) {
		/* can happen if you add a timer with expires == jiffies,
		 * or you set a timer to go off in the past
		 */
		insert_timer(timer, tv1.vec, tv1.index);
	} else if (idx < 0xffffffffUL) {
		int i = (expires >> (TVR_BITS + 3 * TVN_BITS)) & TVN_MASK;
		insert_timer(timer, tv5.vec, i);
	} else {
		/* Can only get here on architectures with 64-bit jiffies */
		timer->next = timer->prev = timer;
	}
}



void add_timer(struct timer_list *timer)
{
	unsigned long flags;
	//save_flags(flags);
	//cli();
#if SLOW_BUT_DEBUGGING_TIMERS
        if (timer->next || timer->prev) {
                printk("add_timer() called with non-zero list from %p\n",
		       __builtin_return_address(0));
		goto out;
        }
#endif
	internal_add_timer(timer);
#if SLOW_BUT_DEBUGGING_TIMERS
out:
#endif
	//restore_flags(flags);
}



/* Very important change here ... greater the value of priority in the *
 * task_struct , heigher is its importance (Linus has opposite meaning)*
 * I dont wanna confuse myself */

void schedule(void)
{
	int c;
	struct task_struct * p;
	struct task_struct * prev, * next;
	unsigned long timeout = 0;

/* check alarm, wake up any interruptible tasks that have got a signal */
//	allow_interrupts();


	need_resched = 0;
	prev = current;
	//	cli();

	if (!prev->counter && prev->policy == SCHED_RR) {
		prev->counter = prev->priority;
		move_last_runqueue(prev);
	}
	switch (prev->state) {
		case TASK_INTERRUPTIBLE:
		  //signals and bottom halves not supported
		  //	if (prev->signal & ~prev->blocked)
		  //		goto makerunnable;
			timeout = prev->timeout;
			if (timeout && (timeout <= jiffies)) {
				prev->timeout = 0;
				timeout = 0;
		makerunnable:
				prev->state = TASK_RUNNING;
				break;
			}
	case TASK_RUNNING:break;
		default:
			del_from_runqueue(prev);
	}
	p = init_task.next_run;
	//sti();
	
#define idle_task (&init_task)
	

/*
 * Note! there may appear new tasks on the run-queue during this, as
 * interrupts are enabled. However, they will be put on front of the
 * list, so our list starting at "p" is essentially fixed.
 */
/* this is the scheduler proper: */
	c = -1000;
	next = idle_task;
	while (p != &init_task) {
		int weight = goodness(p, prev);
		if (weight > c)
			c = weight, next = p;
		p = p->next_run;
	}

    /* if all runnable processes have "counter == 0", re-calculate counters */
	if (c == 0) {
		for_each_task(p)
			p->counter = (p->counter >> 1) +  p->priority;
		schedule(); //after updating counter then calling schedule 
		// again to select the heighest prioritized task
	}

	if (prev != next) {
		struct timer_list timer;

		if (timeout) {
			init_timer(&timer);
			timer.expires = timeout;
			timer.data = (unsigned long) prev;
			timer.function = process_waittimeout;
			add_timer(&timer);
		}

                current = next;

		if (timeout)
			del_timer(&timer);
	}
	return;

scheduling_in_interrupt:
	printk("Aiee: scheduling in interrupt %p\n",
		__builtin_return_address(0));
}
   


 inline int detach_timer(struct timer_list *timer)
{
	int ret = 0;
	struct timer_list *next, *prev;
	next = timer->next;
	prev = timer->prev;
	if (next) {
		next->prev = prev;
	}
	if (prev) {
		ret = 1;
		prev->next = next;
	}
	return ret;
}


extern int del_timer(struct timer_list * timer)
{
	int ret;
	unsigned long flags;
	//save_flags(flags);
	//cli();
	ret = detach_timer(timer);
	timer->next = timer->prev = 0;
	//restore_flags(flags);
	return ret;
}

 inline void cascade_timers(struct timer_vec *tv)
{
        /* cascade all the timers from tv up one level */
        struct timer_list *timer;
        timer = tv->vec[tv->index];
        /*
         * We are removing _all_ timers from the list, so we don't  have to
         * detach them individually, just clear the list afterwards.
         */
        while (timer) {
                struct timer_list *tmp = timer;
                timer = timer->next;
                internal_add_timer(tmp);
        }
        tv->vec[tv->index] = NULL;
        tv->index = (tv->index + 1) & TVN_MASK;
}

 inline void run_timer_list(void)
{
  //cli();
	while ((long)(jiffies - timer_jiffies) >= 0) {
		struct timer_list *timer;
		if (!tv1.index) {
			int n = 1;
			do {
				cascade_timers(tvecs[n]);
			} while (tvecs[n]->index == 1 && ++n < NOOF_TVECS);
		}
		while ((timer = tv1.vec[tv1.index])) {
			void (*fn)(unsigned long) = timer->function;
			unsigned long data = timer->data;
			detach_timer(timer);
			timer->next = timer->prev = NULL;
			//sti();
			fn(data);
			//cli();
		}
		++timer_jiffies; 
		tv1.index = (tv1.index + 1) & TVR_MASK;
	}
       //sti();
}

unsigned long timer_active = 0;
struct timer_struct timer_table[32];

 inline void run_old_timers(void)
{
	struct timer_struct *tp;
	unsigned long mask;

	for (mask = 1, tp = timer_table+0 ; mask ; tp++,mask += mask) {
		if (mask > timer_active)
			break;
		if (!(mask & timer_active))
			continue;
		if (tp->expires > jiffies)
			continue;
		timer_active &= ~mask;
		tp->fn();
		sti();
	}
}



/* This timer just removes the timer from the list of timers     */
/* Note if the timer is a newly created one then it is good practice to */
/* make its all pointers to NULL    */
  
inline void init_timer(struct timer_list * timer)
{
	timer->next = NULL;
	timer->prev = NULL;
}






/*  This one searches the whole timer list for expired timers */
/*  and if expired put the task in the run queue              */

void get_expired_timer()
{
  extern struct timer_list head_timer;
  struct timer_list *p = head_timer.next;
       while(p != &head_timer)
      {
	if(((p->expires) - jiffies) <= 0)
	  { 
	    process_waittimeout(p->data);  /* declared in sched.h */
            del_timer(p);
          }
        p = p->next; 
      }
      return;
}

/* update_process_times increments the number of ticks it had been since
   the system started and decrements the time quatum of current process,
   checks if current process is out of quantum, if yes then it enables
   rescheduling field in it, then it checks for any expired timers in the
   timer_list, if so put all the process whose timers expired in run_queue
   and then returns from the interrupt handler */
void update_process_times()
{   
      struct task_struct * p = current;   
      
        jiffies += 1;
	if(p->pid)
        {
            current->counter -= 1;
            if (current->counter <= 0)
            {
               current->counter = 0;
               need_resched = 1;
            }
            else
              need_resched = 0;
        }


        get_expired_timer();
}





/* init executes this function always */
/* Make this function a user application now it is in kernel which is wrong*/

void init_thread(void)
{ int temp;
 start:
  for(temp=0;temp<HZ;temp++){}
  schedule();
  goto start;
}



/*
 * For backwards compatibility?  This can be done in libc so Alpha
 * and all newer ports shouldn't need it.
 */
int sys_pause(void)
{
	current->state = TASK_INTERRUPTIBLE;
	schedule();
	return -ERESTART;
}

int sys_getpid(void)
{
	return current->pid;
}

int sys_getppid(void)
{
  if(current->p_opptr->pid)
    return current->p_opptr->pid;
  else
    return -10;//current->p_opptr->pid;
}

int sys_getuid(void)
{
	return ENOSYS;
}

int sys_geteuid(void)
{
	return ENOSYS;
}

int sys_getgid(void)
{
	return ENOSYS;
}

int sys_getegid(void)
{
	return ENOSYS;
}

/*
 * This has been replaced by sys_setpriority.  Maybe it should be
 * moved into the arch dependent tree for those ports that require
 * it for backward compatibility?
 */
int sys_nice(int increment)
{
	unsigned long newprio;
	int increase = 0;

	newprio = increment;
	if (increment < 0) {
	  //	if (!suser())
	      //	return -EPERM;
		newprio = -increment;
		increase = 1;
	}
	if (newprio > 40)
		newprio = 40;
	/*
	 * do a "normalization" of the priority (traditionally
	 * unix nice values are -20..20, linux doesn't really
	 * use that kind of thing, but uses the length of the
	 * timeslice instead (default 150 msec). The rounding is
	 * why we want to avoid negative values.
	 */
	newprio = (newprio * DEF_PRIORITY + 10) / 20;
	increment = newprio;
	if (increase)
		increment = -increment;
	newprio = current->priority - increment;
	if ((signed) newprio < 1)
		newprio = 1;
	if (newprio > DEF_PRIORITY*2)
		newprio = DEF_PRIORITY*2;
	current->priority = newprio;
	return 0;
}

 struct task_struct *find_process_by_pid(pid_t pid) {
	struct task_struct *p, *q;

	if (pid == 0)
		p = current;
	else {
		p = 0;
		for_each_task(q) {
			if (q && q->pid == pid) {
				p = q;
				break;
			}
		}
	}
	return p;
}

/* Note here third argument changed a bit from Uclinux codes to suit here */
 int setscheduler(pid_t pid, int policy, 
			int  sched_priority)
{
  //	int error;
  //	struct sched_param lp;
	struct task_struct *p;

	if (pid < 0)
		return -EINVAL;


	p = find_process_by_pid(pid);
	if (!p)
		return -ESRCH;
			
	if (policy < 0)
		policy = p->policy;

	else if (policy != SCHED_FIFO && policy != SCHED_RR &&
		 policy != SCHED_OTHER)
		return -EINVAL;
	
	/*
	 * Valid priorities for SCHED_FIFO and SCHED_RR are 1..99, valid
	 * priority for SCHED_OTHER is 0.
	 */

	if (sched_priority < 0 || sched_priority > 99)
		return -EINVAL;

	if ((policy == SCHED_OTHER) != (sched_priority == 0))
		return -EINVAL;


	p->policy = policy;
	p->rt_priority = sched_priority;
	//	cli();
	if (p->next_run)
		move_last_runqueue(p);
	//	sti();
	need_resched = 1;
	return 0;
}

int sys_sched_setscheduler(pid_t pid, int policy, 
				      int sched_priority)
{
	return setscheduler(pid, policy, sched_priority);
}

int sys_sched_setparam(pid_t pid,int sched_priority)
{
	return setscheduler(pid, -1, sched_priority);
}


int sys_sched_getscheduler(pid_t pid)
{
	struct task_struct *p;

	if (pid < 0)
		return -EINVAL;

	p = find_process_by_pid(pid);
	if (!p)
		return -ESRCH;
			
	return p->policy;
}

int sys_sched_yield(void)
{
  //	cli();
	move_last_runqueue(current);
	current->counter = 0;
	need_resched = 1;
 //	sti();
	return 0;
}

int sys_sched_get_priority_max(int policy)
{
	switch (policy) {
	      case SCHED_FIFO:
	      case SCHED_RR:
		return 99;
	      case SCHED_OTHER:
		return 0;
	}

	return -EINVAL;
}

int sys_sched_get_priority_min(int policy)
{
	switch (policy) {
	      case SCHED_FIFO:
	      case SCHED_RR:
		return 1;
	      case SCHED_OTHER:
		return 0;
	}

	return -EINVAL;
}


/*--------------------------------------------------------------------------*/
/*                 CUP-OS  Syscall,INT and Exception handlers               */
/*              -----------------------------------------------             */
/*  Author   :	Nuguru Susheel Raj                                          */
/*  Email    :	susheel.nuguru@tut.fi                                       */
/*  File     :  entry.c                                                     */
/*  modified :  14/09/2004                                                  */
/*--------------------------------------------------------------------------*/

unsigned long exception_code;
extern long *system_call_table[NR_syscalls];

unsigned int servicing_syscall = 0; /* an interrupt may occer when the processor is executing user tasks or when executing systemcall. This variable along with servicing_interrupt will let us know if user tasks were running before interrupt occured or system task was executing before interrupt occured*/

long servicing_interrupt = 0; /* This will tell us if interrupt occured
while servicing and interrupt  */


/* Macro to add syscall_address into its address with the assumption  *
 * that r16 has address of system_call_table[]'s arrayth address to which this * * entry should be added                                              */

asm(".text\n\t"
    ".align 2\n\t"
    ".global reschedule\n\t"
    ".code32\n\t"
    "reschedule: \n\t"
    "ldra r16,need_resched\n\t "
    "lli r17,0\n\t"
    "st r17,r16,0\n\t"
    "ldra r16,schedule\n\t"
    "push r31\n\t"
    "jalr r16\n\t"
    "nop\n\t"
    "pop r31\n\t"
    "jmp ret_from_sys_call\n\t"
    "nop\n\t");

/* even if the interrupts are enabled in kernel routines it should 
   work fine ..lets test it and find it out in thetesting phase */

extern void system_call(void)
{ 
 servicing_syscall = 1;//switch from task to kernel is true
 asm("disable_interrupts\n\t");
   
  //  SAVE_ALL     No need to save super user registers at syscall entry 
  /*  because at syscall entry the kernel registers have no good information 
     but this is different in the case of interrupt and xception handlers as
     the kernel may be executing at the arrival of IP and xceptions SU 
     registers may have valid information        */
  
   SAVE_USR_PT_REGS
   SAVE_STACK_POINTER
   MOVE_INCOMING_ARGUMENTS


   asm("load_variable(NR_systemcall_A_L,r16)\n\t"  //r16 now has NR_syscalls value
       "cmp c0,r5,r16\n\t"    
       "bgt c0,ret_from_sys_call\n\t"
       "ldra r16,system_call_table\n\t"
       //      "load_variable(_syscalls,r16)\n\t"
       "muli r5,r5,4\n\t"
       "addu r16,r16,r5\n\t"
       "ld r16,r16,0\n\t"
       "push r5\n\t"
       "push r31\n\t"
       "jalr r16\n\t"
       "nop\n\t"
       "pop r31\n\n"
       "pop r5\n\t"
       
       "ret_from_sys_call :\n\t"
       "load_variable(NR_systemcall_A_L,r16)\n\t"  //NR_syscalls into r16
       "cmp c0,r5,r16\n\t"
       "belt c0,f2\n\t"
       "lli r0,75\n\n"    // error number EOVERFLOW returned

/*   Because there is no guarentee that this task will continue before      *
 *   readings its return value in register R0, we will put this value  into *
 *   USR_PT_REGS register 0 */

       "f2      :\n\t"
       "ldra r16,current\n\t"  
       "ld   r1,r16,0\n\t"     
       "addiu r1,r1,pt_regs\n\t"   
       "ld r1,r1,0\n\t"
       "st r0,r1,0\n\t"      
      /*-------------------Done Saving R0-------------------*/

       "load_variable(need_resched,r16)\n\t"
       "cmpi c0,r16,0\n\t"
       "bne  c0,reschedule\n\t"
       "nop\n\t");


  RESTORE_STACK_POINTER
  RESTORE_USR_PT_REGS

  servicing_syscall = 0; //switched from task to kernel is false
    asm("enable_interrupts\n\t");
  //  RESTORE_ALL
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}

/*---------------Done With Scall Handler------------------------*/

extern void interrupt_handler(void)
{

  asm("START_INTERRUPT_HANDLER:\n\t"
      "disable_interrupts\n\t");

	SAVE_ALL
    /* if interrupt occured while kernel service routine continue with
the same stack usage which was used to service the syscall ...else if the
interrupt occured while appllication was running then shift to kernel stack*/
    if(servicing_syscall == 1 || servicing_interrupt >= 1)
      {
        servicing_interrupt += 1;
	/* if anything goes wrong try not storing SP and FP in KERNEL_SP
   and KERENL_FP respectively */

	asm("push r17\n\t"
	    "push r16\n\t"
	    "ldra r17,KERNEL_SP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   SP,r17,0\n\t"
	    "ldra r17,KERNEL_FP\n\t"
	    "ld   r16,r17,0\n\t"
	    "push r16\n\t"
	    "st   FP,r17,0\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      }
    else
      {
        servicing_interrupt = 1;
	servicing_syscall = 0;

 /* set1 SP and FP are undisturbed which have task stack information only 
    set2 SP and FP are corrupted which has no stack information of the kernel
    at this point */
	asm("ldra r17,KERNEL_FP\n\t"   
	    "ld   SP,r17,0\n\t"           
	    "ld   FP,r17,0\n\t"
	    "jmpr r31\n\t"
	    "nop  \n\t");
      }



  asm("Co_Processor0_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor1_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor2_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "Co_Processor3_INT_ISR : \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT0_ISR:\n\t\t" 
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT1_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT2_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT3_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT4_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT5_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"

      "EXT_INT6_ISR:\n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t"


/* Timer interrupt service routine is here */
      "EXT_INT7_ISR: \n\t\t"
      "push LR\n\t\t"
      "ldra r16,START_INTERRUPT_HANDLER\n\t\t"
      "jalr r16\n\t\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,update_process_times\n\t"
      "push LR\n\t"
      "jalr r16\n\t"
      "nop  \n\t\t"
      "pop  LR\n\t\t"
      "ldra r16,final\n\t\t"
      "jmpr r16\n\t\t"
      "nop  \n\t");

  asm("final:\n\t");
   if(servicing_syscall || (servicing_interrupt > 1))
      {
       if(servicing_interrupt > 1)
          servicing_interrupt -= 1 ;
       else
	 {
	   servicing_interrupt = 0;
	   servicing_syscall = 1;
         }
	asm("ldra r17,KERNEL_FP\n\t"
	    "ld FP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "ldra r17,KERNEL_SP\n\t"
	    "ld SP,r17,0\n\t"
	    "pop r16\n\t"
	    "st r16,r17,0\n\t"
	    "pop r16\n\t"
	    "pop r17\n\t");
      }
    else
      {
	servicing_interrupt = 0;
        servicing_syscall = 0;  
      }

	RESTORE_ALL
    asm("enable_interrupts\n\t"
	"reti\n\t\t"
	"nop\n\t\t"
	"nop\n\t"
	"nop\n\t");

}

extern void exception_handler(void)
{
  /* get the exception code*/
  asm("disable_interrupts\n\t"
      "lli r16,0xbf00\n\t"
      "lui r16,0xffff\n\t"
      "ld  r17,r16,EXCEPTION_CS_OFFSET\n\t"
      "ldra r18,exception_code\n\t"
      "st  r17,r18,0\n\t");

  /* now the decision of the exception handler is to make the tasks not able *
   * get the CPU by changing its state to TASK_STOPPED then the scheduler will
   * remove it from the runqueue .in later versions more efficient decisions 
   * have to be made */

  switch(exception_code){
              case 0 :
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 1 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 2 :
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 3 :	
		       current->state = TASK_STOPPED;
		       //del_from_runqueue(current);
		       need_resched = 1;
		       break;
              case 4 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 5 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 6 :
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 7 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 8 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              case 9 :	
		       current->state = TASK_STOPPED;
		       need_resched = 1;
		       break;
              default:
		       if(exception_code >=224)
			 // handle trap here
			 break;
  }
  asm("enable_interrupts\n\t");
}
/*                  CUP-OS       MAIN() is here                             */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

/* the concept of mem_slots[] is here so that sys_fork would be designed in 
   future otherwise now mem_slots are of no use.*/

  /* Need to fill many fields in many structures ... check  *
   * manually and do try to remember those fields           */

// #include "entry.h" uncomment it at the end

#define task_0_address 0123  // task0 = init
#define task_1_address 1
#define task_2_address 2
#define task_3_address 3
#define task_4_address 4

#define task_0_stack_size 0123
#define task_1_stack_size 1
#define task_2_stack_size 2
#define task_3_stack_size 3
#define task_4_stack_size 4

#define STACK_STARTS_AT 1234
#define task0_STACK_START STACK_STARTS_AT
#define task1_STACK_START task0_STACK_START+task_0_stack_size
#define task2_STACK_START task1_STACK_START+task_1_stack_size
#define task3_STACK_START task2_STACK_START+task_2_stack_size
#define task4_STACK_START task3_STACK_START+task_3_stack_size

extern struct task_struct task1;
extern struct task_struct task2;
extern struct task_struct task3;
extern struct task_struct task4;

extern int nr_running;
int mem_slots[MAX_MEMORY_SLOTS];

// --------------------------------------------------------------
// memory information gathering is here
// --------------------------------------------------------------











extern int Global_Pid;

// ________________________________________________________________

  /* here my idea is to build structures manually in the beginning *
   * then for sys_fork automatically using some functions          */
/* r27 and r28 in pt_regs are frame pointe & stack pointer respectively*/

//  struct signal_struct sig4;
 struct mm_struct mm4={0,0,0,0,0,0,0,0,0,3,task_4_stack_size};
 struct pt_regs regs4={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,task4_STACK_START,task4_STACK_START,
			     0,0,task_4_address,0x0019,task_4_address,0
                              };

//   struct signal_struct sig3;
   struct mm_struct mm3={0,0,0,0,0,0,0,0,0,2,task_3_stack_size};
   struct pt_regs regs3={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task3_STACK_START,task3_STACK_START,
			       0,0,task_3_address,0x0019,task_3_address,0
                              };


//   struct signal_struct sig2;
   struct mm_struct mm2={0,0,0,0,0,0,0,0,0,1,task_2_stack_size};
   struct pt_regs regs2={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task2_STACK_START,task2_STACK_START,
			       0,0,task_2_address,0x0019,task_2_address,0
                              };


//   struct signal_struct sig1;
   struct mm_struct mm1={0,0,0,0,0,0,0,0,0,0,task_1_stack_size};
   struct pt_regs regs1={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task1_STACK_START,task1_STACK_START,
                               0,0,task_1_address,0x0019,task_1_address,0
                              };




struct task_struct task1 = {TASK_RUNNING,1,10,NULL,NULL,&init_task,
/* next_run */  &task2,
/* counter  */  40,0,
/* pt_regs  */  &regs1,&mm1,&init_task,&init_task,NULL,NULL,NULL,NULL,
/* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
};


struct task_struct task2 =  {TASK_RUNNING,2,10,NULL,NULL,&task1,
    /* next_run */  &task3,
    /* counter  */  40,0,
    /* pt_regs  */  &regs2,&mm2,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };

struct task_struct task3 =  {TASK_RUNNING,3,10,NULL,NULL,&task2,
    /* next_run */  &task4,
    /* counter  */  40,0,
    /* pt_regs  */  &regs3,&mm3,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };



struct task_struct task4 =  {TASK_RUNNING,4,10,NULL,NULL,&task3,
    /* next_run */  &init_task,
    /* counter  */  40,0,
    /* pt_regs  */  &regs4,&mm4,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };

#define INIT_TASK1 \
/* state    */	  { 0, \
/* Pid      */      0, \
/* priority */      0, \
/* prev_task*/      &init_task, \
/* next_task*/	    &init_task, \
/* prev_run */	    &task4, \
/* next_run */	    &task1, \
/* counter  */      DEF_PRIORITY,  \
/* timeout  */      0,  \
/* pt_regs  */      0,  \
/* mm_struct*/      0,  \
/* proc links*/     &init_task,&init_task,NULL,NULL,NULL,NULL, \
/* policy    */     SCHED_OTHER,INIT_RT_PRIORITY,  \
/* exit_code,..*/   0,0,0,    \
/* signals */       NULL}

struct task_struct init_task = INIT_TASK1; 


void initialize_memory(void)
{
  int i;
  long * pointer;
  /* making all the slots for thememory free for usage */
  for(i=0;i<MAX_MEMORY_SLOTS;i++)
    mem_slots[i] = 0;

  /* The start of stack is the Frame Pointer. Here we make the first FP
     points to itself. That is the contents of the address in FP has the 
     address in which it is stored */

  /*pointer  = (long *)task0_STACK_START;
  *pointer  = task0_STACK_START;  

   pointer  = (long *)task1_STACK_START;
  *pointer  = task1_STACK_START;

   pointer  = (long *)task2_STACK_START;
  *pointer  = task2_STACK_START;

  pointer  = (long *)task3_STACK_START;
  *pointer  = task3_STACK_START;

   pointer  = (long *)task4_STACK_START;
  *pointer  = task4_STACK_START;
  */ //  uncomment this while making executable
  } 


void start_kernel(void)
{
  initialize_memory();

 
  mem_slots[3] = 1;  //fourth slot occupied


  
  mem_slots[2] = 1;  //third slot occupied


  mem_slots[1] = 1;  //second slot occupied


  mem_slots[0] = 1;  //first slot occupied

  Global_Pid  = 5; // i use this after sys_fork is implemented

  current = &task1; /*points to currect task under execution */
  RESTORE_USR_PT_REGS 

  asm("ldra r17,KERNEL_FP\n\t"
      "st FP,r17,0\n\t"
      "enable_interrupts\n\t");// saving kernel fp into a variable kernel_fpx
  
  //  RESTORE_ALL

  servicing_syscall = 0;
  servicing_interrupt = 0;
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}


void Print_Runqueue( )
{
	struct task_struct* tmp_init = init_task.next_run;


	//Adding these printf bcos PrintTaskStruct doesnt print INIT
	//       printf("\n\nPID:: 0,  PRIORITY:: 1 ----> INIT\n");

      while ( tmp_init != &init_task)
	{
	  //              printf("PID:: %d,  PRIORITY:: %d\n",tmp_init->pid, tmp_init->priority);
	      tmp_init=tmp_init->next_run;
	}	;       

}


int maintain()
{ 
  /* set2 sp and fp are to be initialized here, i forgot them .. let me 
     initialize them in boot.x  bcos main willbe called after boot.x  */

  start_kernel();
  asm("retu\n\t"
      "nop\n\t"
      "nop\n\t"); //these are never executed
  return 0; 
}

asm(".code32\n\t"
    "xor r0,r0,r0\n\t"
    "ldri r0,1\n\t"
    "xor r1,r1,r1\n\t"
    "add r1,r1,r0\n\t"
    "jmp -4\n\t"
    "nop\n\t"); 

asm(
    "xor r0,r0,r0\n\t"
    "ldri r0,1\n\t"
    "xor r1,r1,r1\n\t"
    "add r1,r1,r0\n\t"
    "jmp -4\n\t"
    "nop\n\t"); 

asm(
    "xor r0,r0,r0\n\t"
    "ldri r0,1\n\t"
    "xor r1,r1,r1\n\t"
    "add r1,r1,r0\n\t"
    "jmp -4\n\t"
    "nop\n\t"); 
asm(
    "xor r0,r0,r0\n\t"
    "ldri r0,1\n\t"
    "xor r1,r1,r1\n\t"
    "add r1,r1,r0\n\t"
    "jmp -4\n\t"
    "nop\n\t"); 
