/*                  CUP-OS       MAIN() is here                             */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/

/* the concept of mem_slots[] is here so that sys_fork would be designed in 
   future otherwise now mem_slots arent used.*/

#include "all_macros.h"
#include "sched.h"
#include "library/coffee.h" /* so that system calls can be used inside the kernel */
#include "entry.h"
#include "all_definitions.h"

/* If anyone adds more tasks then do not forget to change the fields
   of the INIT_TASK in sched.h else the new added task are not recognised
   by the kernel or even worse the system may crash :-( */

extern unsigned int Global_Pid;
extern unsigned int servicing_syscall;
extern long servicing_interrupt;
void idle_brain();

#define task_0_address (int)&idle_brain  // task0 = idle_task
#define task_1_address 15088
#define task_2_address 15144
#define task_3_address 15200
#define task_4_address 15256

#define task_0_stack_size 1000
#define task_1_stack_size 1000
#define task_2_stack_size 1000
#define task_3_stack_size 1000
#define task_4_stack_size 1000

#define STACK_STARTS_AT 100000
#define task0_STACK_START STACK_STARTS_AT
#define task1_STACK_START task0_STACK_START+task_0_stack_size
#define task2_STACK_START task1_STACK_START+task_1_stack_size
#define task3_STACK_START task2_STACK_START+task_2_stack_size
#define task4_STACK_START task3_STACK_START+task_3_stack_size

extern struct task_struct task1;
extern struct task_struct task2;
extern struct task_struct task3;
extern struct task_struct task4;

extern int nr_running;
int mem_slots[MAX_MEMORY_SLOTS];

// --------------------------------------------------------------
// memory information gathering is here
// --------------------------------------------------------------








// ________________________________________________________________

  /* here the idea is to build structures manually in the beginning *
   * then for sys_fork automatically using some functions          */
/* r27 and r28 in pt_regs are frame pointe & stack pointer respectively*/

//  struct signal_struct sig4;
 struct mm_struct mm4={0,0,0,0,0,0,0,0,0,3,task_4_stack_size};
 struct pt_regs regs4={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,task4_STACK_START,task4_STACK_START,
			     0,0,task_4_address,0x0019,task_4_address,0
                              };

//   struct signal_struct sig3;
   struct mm_struct mm3={0,0,0,0,0,0,0,0,0,2,task_3_stack_size};
   struct pt_regs regs3={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task3_STACK_START,task3_STACK_START,
			       0,0,task_3_address,0x0019,task_3_address,0
                              };


//   struct signal_struct sig2;
   struct mm_struct mm2={0,0,0,0,0,0,0,0,0,1,task_2_stack_size};
   struct pt_regs regs2={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                               0,0,0,0,0,0,0,task2_STACK_START,task2_STACK_START,
			       0,0,task_2_address,0x0019,task_2_address,0
                              };


//   struct signal_struct sig1;
   struct mm_struct mm1={0,0,0,0,0,0,0,0,0,0,task_1_stack_size};
   struct pt_regs regs1={1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,0,0,0,0,0,
                               0,0,0,0,0,0,0,task1_STACK_START,task1_STACK_START,
                               0,0,task_1_address,0x0019,task_1_address,0
                              };

struct mm_struct mm0= {0,0,0,0,0,0,0,0,0,0,task_0_stack_size};
struct pt_regs init_ptregs = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                              0,0,0,0,0,0,0,0,0,0,0,task0_STACK_START,
			      task0_STACK_START,0,0,task_0_address,0x0019,
			      task_0_address,0};


struct task_struct task1 = {TASK_RUNNING,1,10,NULL,NULL,&init_task,
/* next_run */  &task2,
/* counter  */  3,0,
/* pt_regs  */  &regs1,&mm1,&init_task,&init_task,NULL,NULL,NULL,NULL,
/* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
};


struct task_struct task2 =  {TASK_RUNNING,2,10,NULL,NULL,&task1,
    /* next_run */  &task3,
    /* counter  */  3,0,
    /* pt_regs  */  &regs2,&mm2,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };

struct task_struct task3 =  {TASK_RUNNING,3,10,NULL,NULL,&task2,
    /* next_run */  &task4,
    /* counter  */  3,0,
    /* pt_regs  */  &regs3,&mm3,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };



struct task_struct task4 =  {TASK_RUNNING,4,10,NULL,NULL,&task3,
    /* next_run */  &init_task,
    /* counter  */  3,0,
    /* pt_regs  */  &regs4,&mm4,&init_task,&init_task,NULL,NULL,NULL,NULL,
    /* wait_queue */SCHED_OTHER,/*rt_priority*/ 20,0,0,1,0
  };






void initialize_memory(void)
{
  int i;
  long * pointer;
  /* making all the slots for thememory free for usage */
  for(i=0;i<MAX_MEMORY_SLOTS;i++)
    mem_slots[i] = 0;

  /* The start of stack is the Frame Pointer. Here we make the first FP
     points to itself. That is the contents of the address in FP has the 
     address in which it is stored */

  pointer  = (long *)task0_STACK_START;
  *pointer  = task0_STACK_START;  

   pointer  = (long *)task1_STACK_START;
  *pointer  = task1_STACK_START;

   pointer  = (long *)task2_STACK_START;
  *pointer  = task2_STACK_START;

  pointer  = (long *)task3_STACK_START;
  *pointer  = task3_STACK_START;

   pointer  = (long *)task4_STACK_START;
  *pointer  = task4_STACK_START;
  
  } 


void start_kernel(void)
{
  initialize_memory();

 
  mem_slots[3] = 1;  //fourth slot occupied


  
  mem_slots[2] = 1;  //third slot occupied


  mem_slots[1] = 1;  //second slot occupied


  mem_slots[0] = 1;  //first slot occupied

  Global_Pid  = 5; // this could be useful after sys_fork is implemented

  current = &task1; /*points to currect task under execution */
  RESTORE_USR_PT_REGS; 

  asm("ldra r17,KERNEL_FP\n\t"
      "st FP,r17,0\n\t"
      "ldra r17,KERNEL_SP\n\t"
      "st SP,r17,0\n\t"
      "enable_interrupts\n\t");// saving kernel fp into a variable kernel_fpx
  
  //  RESTORE_ALL

  servicing_syscall = 0;
  servicing_interrupt = 0;
asm("retu\n\t"
"nop\n\t"
"nop\n\t");
}


void Print_Runqueue( )
{
	struct task_struct* tmp_init = init_task.next_run;


	//Adding these printf bcos PrintTaskStruct doesnt print INIT
	//       printf("\n\nPID:: 0,  PRIORITY:: 1 ----> INIT\n");

      while ( tmp_init != &init_task)
	{
	  //              printf("PID:: %d,  PRIORITY:: %d\n",tmp_init->pid, tmp_init->priority);
	      tmp_init=tmp_init->next_run;
	}	;       

}


int maintain()
{ 
  /* set2 sp and fp are to be initialized here, i forgot them .. let me 
     initialize them in boot.x  bcos main willbe called after boot.x  */

  start_kernel();
  asm("\n\tretu\n\t"
      "nop\n\t"
      "nop\n\t"); //these are never executed
  return 0; 
}

/* Idle Task which is runned by INIT when no other application is running */
void idle_brain()
{long tin;
  asm("\n\tei    \n\t"
      "nop   \n\t");
  for(;;)
    {
      for(tin=0;tin < 1000000;tin++)
	{}
      dummy_idle_brain();  /*dummy sys_call to check if any interrupt changed
                            anything on the runqueue */
    }
}
