#include "errno.h"
#define DYNAMIC_MEMORY_STARTS_AT 0x01200
#define NULL ((void *) 0)

static unsigned long free_mem_ptr = DYNAMIC_MEMORY_STARTS_AT;
static unsigned long free_mem_end_ptr = 0x90000;


/* ENOMEM and ENXIO are selected to me odd .. if these values are
   even,then the return values are type casted by the the caller and the
   error value will be assumed to be the pointer returned...if it is odd
   then there will be an exception and the kernel removes this task from 
   the current running list */

static void *sys_malloc(int size)
{
	void *p;

	if (size <0) return NULL  ;
	if (free_mem_ptr <= 0) 
		free_mem_ptr = 0;

		free_mem_ptr = (free_mem_ptr + 3) & ~3;	/* Align */

	if ((free_mem_ptr + size) >= free_mem_end_ptr)
	       return NULL;

	p = (void *)free_mem_ptr;
	free_mem_ptr += size;
	
	return p;
}


static void sys_free(void *where)
{	/* Don't care */
}
