/*                    QPUX-Kernel Some more routines                        */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/


#include "errno.h" 
#include "sched.h"

extern struct task_struct *current;
extern unsigned long volatile jiffies;
extern int need_resched;
 int hlt_counter=0;
char hlt_works_ok = 0;		/* set if the "hlt" instruction works */

#define HARD_IDLE_TIMEOUT (HZ / 3)

void disable_hlt(void)
{
	hlt_counter++;
}

void enable_hlt(void)
{
	hlt_counter--;
}


 void hard_idle(void)
{
	while (!need_resched) {
		if (hlt_works_ok && !hlt_counter)
		        //__asm__("hlt");         
 		if (need_resched) 
 			break;
		schedule();
	}
}

/*
 * The idle loop on a uniprocessor coffee..
 */
 
int sys_idle(void)
{
        unsigned long start_idle = 0;

	if (current->pid)
		return -EPERM;
	/* endless idle loop with no priority at all */
	current->counter = -100;
	for (;;) 
	{

		if (!start_idle) 
			start_idle = jiffies;
		if (jiffies - start_idle > HARD_IDLE_TIMEOUT) 
		{
			hard_idle();
		} 
		else 
		{
			if (hlt_works_ok && !hlt_counter && !need_resched){}
		        	//__asm__("hlt");
		}
		if (need_resched) 
			start_idle = 0;
		schedule();
	}
}
