/*                    QPUX-Kernel Schedulingg Header File                   */
/*              -------------------------------------------                 */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  --->                                                  */
/*--------------------------------------------------------------------------*/
#ifndef __SCHED__
#define __SCHED__

#include "signal.h"
#define MAX_MEMORY_SLOTS 4

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define DEF_PRIORITY	(20*HZ/100)	/* 200 ms time slices */
#define NR_TASKS     10     /*total number of tasks allowed including from INIT */

/* different states a task can have */
#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_WAITING		3
#define TASK_STOPPED		4
#define TASK_SWAPPING		5

/*
 * Scheduling policies
 */
#define SCHED_OTHER		0
#define SCHED_FIFO		1
#define SCHED_RR		2

/*
 * Limit the stack by to some sane default: root can always
 * increase this limit if needed..  8MB seems reasonable.
 */
#define _STK_LIM	(8*1024*1024)
#define INIT_RT_PRIORITY 15

/* 
 * User task cannot run more than SYSCALL_CALLED_TIMER_MAX timer units without 
 * calling a system call. If it did then the task will be put in the TASK_STOPPED
 * state, which would make the scheduler not to select it at any time as this is task not put 
 * on the wait queue its information will lost by the kernel (wantedly lost)
 */
#define SYSCALL_CALLED_TIMER_MAX 200 

/*
 * Per process flags
 */
#define PF_ALIGNWARN	0x00000001	/* Print alignment warning msgs */
					/* Not implemented yet, only for 486*/
#define PF_PTRACED	0x00000010	/* set if ptrace (0) has been called. */
#define PF_TRACESYS	0x00000020	/* tracing system calls */
#define PF_FORKNOEXEC	0x00000040	/* forked but didn't exec */
#define PF_SUPERPRIV	0x00000100	/* used super-user privileges */
#define PF_DUMPCORE	0x00000200	/* dumped core */
#define PF_SIGNALED	0x00000400	/* killed by a signal */

#define PF_STARTING	0x00000002	/* being created */
#define PF_EXITING	0x00000004	/* getting shut down */ 

#define PF_USEDFPU	0x00100000	/* Process used the FPU this quantum (SMP only) */

struct sched_param {
	int sched_priority; 
};

typedef int pid_t;


#define QUANTUM 100        //runtime quantum for a process

extern unsigned long volatile jiffies;
extern struct task_struct init_task;
extern struct signal_struct init_signals;
extern struct pt_regs init_ptregs;
extern struct task_struct * current;
extern struct mm_struct mm0;


/* -------------------------------------------------------*/
/*           Included from timer.h file to here           */
/* -------------------------------------------------------*/

#define HZ 50000000     /* frequency at which COFFEE is working now      */
#define WAIT_TIME 4     /* number of ticks a process waits in wait queue */

struct timer_struct {
	unsigned long expires;
	void (*fn)(void);
}; /*for now i am not using this but i may use it in future*/


/*
 * The "data" field is in case you want to use the same
 * timeout function for several timeouts. You can use this
 * to distinguish between the different invocations.
 */
struct timer_list {
	struct timer_list *next;
	struct timer_list *prev;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);
};


/************************FUNCTIONS PROTOTYPES ARE HERE*************************/
void initialize_timers();
void init_timer(struct timer_list * timer);
void process_waittimeout (unsigned long data);
//void add_timer(struct timer_list * timer);
int del_timer(struct timer_list *);
void add_timer(struct timer_list *);
void update_process_times(); 
void get_expired_timer();

/************************FUNCTION PROTOTYPES ENDS HERE*************************/
 

/* This is going to be the header of all timer list just like  INIT_TASK */

#define INIT_TIMER  \
/* next     */	  { &head_timer, \
/* prev     */      &head_timer, \
/* expires  */      0x7D0,   \
/* data     */    (unsigned long) &head_timer, \
/* function */    process_waittimeout  \
  }
/*------------DONE WITH timer.h----------------------*/

/*
 * This struct defines the way the registers are stored on the stack during *
 * a system call/exception. I am saving all registers no compromise, bcos i *
 * am a bad GUY :-).  */

/* change anything here then also change in entry.c */

struct pt_regs { 
	/*
	 * saved current process registers
	 */
	long	 reg0,  reg1,  reg2,  reg3,  reg4,  reg5,  reg6,  reg7;
	long	 reg8,  reg9, reg10, reg11, reg12, reg13, reg14, reg15;
	long	reg16, reg17, reg18, reg19, reg20, reg21, reg22, reg23;
        long	reg24, reg25, reg26, reg27, reg28, reg29, reg30, reg31;

	/*
	 * Saved special registers
	 */
	long	spsr;
        long    LR;
  long  conditional_regs;
  long  su_reg0; // for saving system call return values
};


struct mm_pointers {
  long start;
  long end;
};

/************************FUNCTIONS PROTOTYPES ARE HERE************************/
void Print_Runqueue( );
struct task_struct * ScheduleTaskStruct();
void schedule(void);

void add_to_runqueue(struct task_struct * );
void add_to_waitqueue(struct task_struct *);
inline void del_from_runqueue(struct task_struct *);
inline void wake_up_process(struct task_struct * p);
inline void move_last_runqueue(struct task_struct * p);
inline int goodness(struct task_struct * p, struct task_struct * prev);
/************************FUNCTION PROTOTYPES ENDS HERE************************/

/* changing order for these might result in system crash.. change at ur own *
 * risk and if u know the consequences. If u wanna add something,add at the*
 * end  of structure */

extern struct task_struct task1;
extern struct task_struct task2;
extern struct task_struct task3;
extern struct task_struct task4;


#define INIT_TASK \
/* state    */	  { TASK_RUNNING, \
/* Pid      */      0, \
/* priority */      10, \
/* prev_task*/      &init_task, \
/* next_task*/	    &init_task, \
/* prev_run */	    &task4, \
/* next_run */	    &task1, \
/* counter  */      DEF_PRIORITY,  \
/* timeout  */      0,  \
/* pt_regs  */      &init_ptregs,  \
/* mm_struct*/      &mm0,  \
/* proc links*/     &init_task,&init_task,NULL,NULL,NULL,NULL, \
/* policy    */     SCHED_OTHER,INIT_RT_PRIORITY,  \
/* exit_code,..*/   0,0,0,    \
/* signals */       0}


struct task_struct{
        int state;
        int pid;
	int priority;
        struct task_struct *prev_task,*next_task;
        struct task_struct *prev_run, *next_run;
        long counter;
        unsigned long timeout;
        struct pt_regs *regs;
        struct mm_struct *mm;
	struct task_struct *p_opptr, *p_pptr, *p_cptr, *p_ysptr, *p_osptr;
	struct wait_queue *wait_chldexit;	/* for wait4() */
        unsigned long policy,rt_priority;
	int exit_code, exit_signal;
	unsigned long signal;
/* signal handlers */ 
	struct signal_struct *sig;
        struct timer_list timer;
        int syscall_called_timer; //  If equals to 2000 then delete this task
                                   //  from runqueue
};

  
struct mm_struct {
        unsigned long start_code,end_code;
        unsigned long start_data, end_data,start_kernel_stack;//,kernel_sp;
	unsigned long task_sp,task_fp,end_stack;
	unsigned long def_flags;
        unsigned int memory_slot;
        unsigned int task_stack_size;
};

#define INIT_MM { \
		1, \
		((unsigned long)&idle_brain()), 0, 0, 0, \
		0, 0, 0, 0, \
		0, 0, 0, 0, \
        	0, 0}


#ifndef NULL
#define NULL ((void *) 0)
#endif

#define for_each_task(p) \
	for (p = &init_task ; (p = p->next_run) != &init_task ; )

#endif //_SCHED__
