/*                    QPUX-Kernel Harware Stuff File                        */
/*              ---------------------------------------                     */
/*  Author            ---> Nuguru Susheel Raj                               */
/*  Modified by       ---> Nuguru Susheel Raj                               */
/*  Email-ID          ---> susheel.nuguru@tut.fi                            */
/*  Last Modified on  ---> 20/09/05                                         */
/*--------------------------------------------------------------------------*/


#include "errno.h" 
#include "sys.h"
#include "sched.h"

/* So many cases are taken assuming that they will be implemented in *
 * in near future */


 int proc_sel(struct task_struct *p, int which, int who)
{
	if(p->pid)
	{
		switch (which) {
			case PRIO_PROCESS:
				if (!who && p == current)
					return 1;
				return(p->pid == who);
			case PRIO_PGRP:
			  /*	if (!who)
					who = current->pgrp;
					return(p->pgrp == who);*/
			        break;
			case PRIO_USER:
			  /*if (!who)
					who = current->uid;
					return(p->uid == who);*/
			  break;
		}
	}
	return 0;
} 

int sys_setpriority(int which, int who, int niceval)
{
	struct task_struct *p;
	int error = ESRCH;
	unsigned int priority;

	if (which > 2 || which < 0)
		return -EINVAL;

	/* normalize: avoid signed division (rounding problems) */
	priority = niceval;
	if (niceval < 0)
		priority = -niceval;
	if (priority > 20)
		priority = 20;
//	priority = (priority * DEF_PRIORITY + 10) / 20 + DEF_PRIORITY;

		if (!priority)
			priority = 1;

	for_each_task(p) {
		if (!proc_sel(p, which, who))
			continue;

		if (error == ESRCH)
			error = 0;
     //		if (priority > p->priority && !suser())
	   //		error = EACCES;
		else
			p->priority = priority;
	}
	return -error;
}


/*
 * Ugh. To avoid negative return values, "getpriority()" will
 * not return the normal nice-value, but a value that has been
 * offset by 20 (ie it returns 0..40 instead of -20..20)
 */
int sys_getpriority(int which, int who)
{
	struct task_struct *p;
	long max_prio = -ESRCH;

	if (which > 2 || which < 0)
		return -EINVAL;

	for_each_task (p) {
		if (!proc_sel(p, which, who))
			continue;
		if (p->priority > max_prio)
			max_prio = p->priority;
	}

	/* scale the priority from timeslice to 0..40 */
//	if (max_prio > 0)
//		max_prio = (max_prio * 20 + (DEF_PRIORITY>>1)) / DEF_PRIORITY;
	return max_prio;
}

void machine_reboot()
{ 
/* Here we can use Timer1 instead of Timer0 but doesnt matter as this is a reboot */
   asm("push r10\n\t"
       "push r11\n\t"
       "xor  r10,r10,r10\n\t"
       "lli  r10,CCB_BASE_REMAPPED_LO          //defined in boot.x \n\t"
       "lui  r10,CCB_BASE_REMAPPED_HI          //defined in boot.x \n\t"
       "lli  r11,0xf7ff\n\t"
       "st   r11,r10,37\n\t"
       "pop r11\n\t"
       "pop r10\n\t"
);
/* FIXME : Is pushing and poping really necessary here, because after reboot those register contents are
 *         not valid/required anymore. Developers please have your stop here and think a bit, reducing a couple
 *         of instructions is not bad anyhow :-)
 */

}


long sys_reboot(int magic1, int magic2,unsigned int cmd)
{
        
	if (magic1 != LINUX_REBOOT_MAGIC1 ||
	    magic2 != LINUX_REBOOT_MAGIC2)
		return -EINVAL;

	switch (cmd) {
	case LINUX_REBOOT_CMD_RESTART:
		machine_reboot();
		/* Now wait for watchdog timer to expire */		
		for(;;)
                {}
		break;

	case LINUX_REBOOT_CMD_CAD_ON:
	  //break;

	case LINUX_REBOOT_CMD_CAD_OFF:
	  //break;

	case LINUX_REBOOT_CMD_HALT:
	  //break;

	case LINUX_REBOOT_CMD_POWER_OFF:
	  //break;

	case LINUX_REBOOT_CMD_RESTART2:
	  //break;

	case LINUX_REBOOT_CMD_SW_SUSPEND:
	  //break;

	default:
		return -EINVAL;
	}
	return 0;
}

int sys_profil(void)
{
	return -ENOSYS;
}

int sys_ftime(void)
{
	return -ENOSYS;
}

int sys_break(void)
{
	return -ENOSYS;
}

int sys_stty(void)
{
	return -ENOSYS;
}

int sys_gtty(void)
{
	return -ENOSYS;
}

int sys_prof(void)
{
	return -ENOSYS;
}
